/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#ifndef _MEM_TRANSFER_H
#define _MEM_TRANSFER_H

void initialize_clip_table();

void    transfer_16to8copy(uint8 * const restrict dst,
                           int16 * const restrict src, xint stride);

void    transfer_16to8add(uint8 * const restrict dst,
                          int16 * const restrict src, xint stride);
void    transfer8x8_copy(uint8 * dst, uint8 * src, const int stride,
                         const int dst_stride, const int nouse);

#endif /* _MEM_TRANSFER_H_ */
